/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.comp;

import DE.siemens.ad.logo.app.comp.LengthRestrictedJTextField;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.StringTokenizer;

public class DoubleJTextField
extends LengthRestrictedJTextField {
    boolean fSign = false;
    int fVorkommastellen = 3;
    int fNachkommastellen = 2;
    public String pattern = "##.##";
    public double min = 0.0;
    public double max = 0.0;
    public LogoError error;
    char fDecimalSeparator;
    protected DecimalFormat decimalFormat;

    public DoubleJTextField() {
        this(DoubleJTextField.getDefaultPattern());
    }

    public DoubleJTextField(String pattern) {
        this.setHorizontalAlignment(4);
        this.fDecimalSeparator = new DecimalFormat().getDecimalFormatSymbols().getDecimalSeparator();
        this.setPattern(pattern);
        this.setValue(0.0);
    }

    public boolean checkChanged() {
        return this.parseNumber(this.getInitialValue()) != this.getValue();
    }

    public boolean checkValue() {
        boolean rw = true;
        double value = this.getValue();
        if (value > this.max || value < this.min) {
            rw = false;
        }
        if (!rw && this.error != null) {
            this.error.display();
        }
        return rw;
    }

    public boolean checkValue(boolean notify) {
        boolean result = true;
        double value = this.getValue();
        if (this.max > this.min) {
            if (value > this.max || value < this.min) {
                result = false;
            }
        } else if (value > this.min || value < this.max) {
            result = false;
        }
        if (notify && !result && this.error != null) {
            this.error.display();
        }
        return result;
    }

    public LogoError createDefaultError() {
        Object[] parameters = new Object[]{new Float(this.getMin()), new Float(this.getMax())};
        return this.createError("error.dialog.invalidFloatValue", "Invalid Value. Please enter an value between " + this.getMin() + " and " + this.getMax() + ".");
    }

    public LogoError createError(String ErrorKey, String DefaultErrorText) {
        Object[] parameters = new Object[]{new Float(this.getMin()), new Float(this.getMax())};
        return new LogoError((Component)this, ErrorKey, DefaultErrorText, parameters, 0, 0);
    }

    String formatNumber(double number) {
        String numberString = this.decimalFormat.format(number);
        return numberString;
    }

    private double getCorrectValue(double value) {
        if (value < this.min) {
            value = this.min;
        }
        if (value > this.max) {
            value = this.max;
        }
        return value;
    }

    public String getDefaultInitialValue() {
        return "0.00";
    }

    protected static String getDefaultPattern() {
        return "0.00";
    }

    public LogoError getError() {
        if (this.error == null) {
            this.error = this.createDefaultError();
        }
        return this.error;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public String getPattern() {
        return this.pattern;
    }

    public synchronized double getValue() {
        return this.parseNumber(this.getText());
    }

    public boolean isValidString(String str) {
        if (this.fSign && (str.startsWith("-") || str.startsWith("+"))) {
            str = str.substring(1);
        }
        int decimalPointPosition = str.indexOf(this.fDecimalSeparator);
        if (this.fNachkommastellen == 0 && decimalPointPosition != -1) {
            for (int i = decimalPointPosition + 1; i < str.length(); ++i) {
                if (str.charAt(i) == this.fDecimalSeparator) continue;
                return false;
            }
            return true;
        }
        char[] cstr = str.toCharArray();
        for (int i = 0; i < cstr.length; ++i) {
            if (Character.isDigit(cstr[i]) || cstr[i] == this.fDecimalSeparator) continue;
            return false;
        }
        if (str.indexOf(this.fDecimalSeparator) != str.lastIndexOf(this.fDecimalSeparator)) {
            return false;
        }
        if (str.indexOf(this.fDecimalSeparator) == -1) {
            return str.length() <= this.fVorkommastellen;
        }
        if (str.startsWith(String.valueOf(this.fDecimalSeparator))) {
            return str.substring(1).length() <= this.fNachkommastellen;
        }
        StringTokenizer st = new StringTokenizer(str, String.valueOf(this.fDecimalSeparator));
        if (st.hasMoreTokens() && st.nextToken().length() > this.fVorkommastellen) {
            return false;
        }
        return !st.hasMoreTokens() || st.nextToken().length() <= this.fNachkommastellen;
    }

    protected double parseNumber(String number) {
        Number n = null;
        try {
            n = this.decimalFormat.parse(number);
        }
        catch (ParseException pe) {
            return 0.0;
        }
        return n.doubleValue();
    }

    public void setError(LogoError newValue) {
        this.error = newValue;
    }

    public void setInitialValue(double newValue) {
        this.setValue(newValue);
        super.setInitialValue(super.getText());
    }

    public void setMax(double newValue) {
        this.max = newValue;
    }

    public void setMin(double newValue) {
        this.min = newValue;
    }

    public void setPattern(String str) throws IllegalArgumentException {
        StringTokenizer st;
        this.pattern = str;
        if (str.startsWith("-")) {
            this.fSign = true;
            str = str.substring(1);
        }
        if (str.indexOf(".") != str.lastIndexOf(".")) {
            throw new IllegalArgumentException(Language.getString("error.dialog.comp.floatTextField.decimalPoint", "More than one decimal points."));
        }
        if (str.indexOf(".") == -1) {
            this.fVorkommastellen = str.length();
            this.fNachkommastellen = 0;
        }
        if (str.startsWith(".")) {
            this.fVorkommastellen = 0;
            this.fNachkommastellen = str.length() - 1;
        }
        if ((st = new StringTokenizer(str, ".")).hasMoreTokens()) {
            this.fVorkommastellen = st.nextToken().length();
        }
        if (st.hasMoreTokens()) {
            this.fNachkommastellen = st.nextToken().length();
        }
        this.decimalFormat = new DecimalFormat(str);
        this.decimalFormat.setMinimumFractionDigits(this.fNachkommastellen);
        this.decimalFormat.setDecimalSeparatorAlwaysShown(this.fNachkommastellen != 0);
        this.pattern = str;
        this.setColumns(this.pattern.length());
    }

    public synchronized void setValue(double newValue) {
        String valueString = this.formatNumber(newValue = this.getCorrectValue(newValue));
        if (!this.isValidString(valueString)) {
            throw new IllegalArgumentException("Value passt nicht zur Formatmaske");
        }
        this.setText(valueString);
    }
}

